/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.markup;

import club.sk1er.org.apache.commons.lang3.StringUtils;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.languagetool.markup.TextPart;

public class AnnotatedText {
    private final List<TextPart> parts;
    private final Map<Integer, Integer> mapping;
    private final Map<MetaDataKey, String> metaData;
    private final Map<String, String> customMetaData;

    AnnotatedText(List<TextPart> parts, Map<Integer, Integer> mapping, Map<MetaDataKey, String> metaData, Map<String, String> customMetaData) {
        this.parts = Objects.requireNonNull(parts);
        this.mapping = Objects.requireNonNull(mapping);
        this.metaData = Objects.requireNonNull(metaData);
        this.customMetaData = Objects.requireNonNull(customMetaData);
    }

    public String getOriginalText() {
        StringBuilder sb = new StringBuilder();
        for (TextPart part : this.parts) {
            if (part.getType() != TextPart.Type.TEXT) continue;
            sb.append(part.getPart());
        }
        return sb.toString();
    }

    public String getPlainText() {
        StringBuilder sb = new StringBuilder();
        for (TextPart part : this.parts) {
            if (part.getType() != TextPart.Type.TEXT && part.getType() != TextPart.Type.FAKE_CONTENT) continue;
            sb.append(part.getPart());
        }
        return sb.toString();
    }

    public String getTextWithMarkup() {
        StringBuilder sb = new StringBuilder();
        for (TextPart part : this.parts) {
            if (part.getType() == TextPart.Type.FAKE_CONTENT) continue;
            sb.append(part.getPart());
        }
        return sb.toString();
    }

    public int getOriginalTextPositionFor(int plainTextPosition) {
        if (plainTextPosition < 0) {
            throw new IllegalArgumentException("plainTextPosition must be >= 0: " + plainTextPosition);
        }
        Integer origPosition = this.mapping.get(plainTextPosition);
        if (origPosition != null) {
            return origPosition;
        }
        int minDiff = Integer.MAX_VALUE;
        Integer bestMatch = null;
        for (Map.Entry<Integer, Integer> entry : this.mapping.entrySet()) {
            int diff;
            int maybeClosePosition = entry.getKey();
            if (plainTextPosition <= maybeClosePosition || (diff = plainTextPosition - maybeClosePosition) < 0 || diff >= minDiff) continue;
            bestMatch = entry.getValue();
            minDiff = diff;
        }
        if (bestMatch == null) {
            throw new RuntimeException("Could not map " + plainTextPosition + " to original position");
        }
        return bestMatch + minDiff;
    }

    public String getGlobalMetaData(String key, String defaultValue) {
        return this.customMetaData.getOrDefault(key, defaultValue);
    }

    public String getGlobalMetaData(MetaDataKey key, String defaultValue) {
        return this.metaData.getOrDefault((Object)key, defaultValue);
    }

    public String toString() {
        return StringUtils.join(this.parts, "");
    }

    public static enum MetaDataKey {
        DocumentTitle,
        EmailToAddress,
        EmailNumberOfAttachments;

    }
}

